#!/bin/sh
#
#	Create mpeg file for FreeBSD.
#
# require packages:
#	ImageMagick(convert), mjpegtools(jpeg2yuv, mpeg2enc), ffmpeg.
#
# usage:
#	let .bmp files contain directory name, then create mpeg to name.mp4.
#
if [ $# -lt 1 ]; then
	echo usage: $0 write-mpeg4video-file-name-and-directory
	exit 1
fi
WKDIR=$1
#mkdir $WKDIR
N=0
W=1
for i in $WKDIR/*.bmp; do
	L=`echo "$i" | sed s%$WKDIR\\\\/%% | sed s/.bmp// | wc -L`
	if [ $W -lt $L ]; then
		W=`echo $L`
	fi
done
for i in $WKDIR/*.bmp; do
	N=`printf %0${W}d $N`
	echo "$i" "$N"
	convert $i -quality 100 -sampling-factor 2x1,1x1,1x1 $WKDIR/${N}.jpg
	N=`expr $N + 1`
done
rm ${1}.mp4
jpeg2yuv -f 29.97 -L 0 -I p -n $N -j $WKDIR/%0${W}d.jpg | mpeg2enc -F 4 -f 13 -b 20480 -o ${1}.m2v
ffmpeg -i ${1}.m2v -f mp4 -vcodec h264 ${1}.mp4
#rm ${1}.m2v
#rm -rf $WKDIR
