#include <cerrno>
#include <iostream>
#include <fstream>
using namespace std;
#include "dsf.h"
#include "dsf_load.h"
int main(int argc, char **argv)
{
	if (argc <= 1) {
		cout << "usage: " << argv[0] << " <dsf file...>" << endl;
		return	0;
	}
	for (int i=1; i< argc; i++) {
		ifstream	ifs;
		dsf_t	dsf;
		bool	r;
		ifs.open(argv[i]);
		if (!ifs) {
			cerr << argv[i] << ": " << strerror(errno) << endl;
			return	1;
		}
		r = dsf_load(dsf, ifs);
		if (!r) {
			cerr << argv[i] << ": dsf load error." << endl;
			return	1;
		}
		cout << "filename: " << argv[1] << endl;
		cout << "filesize: " << dsf.filesize << endl;
		cout << "id3v2ptr: " << dsf.id3v2ptr << endl;
		cout << "channeltype: " << dsf.channeltype << endl;
		cout << "channelnum: " << dsf.channelnum << endl;
		cout << "frequency: " << dsf.frequency << endl;
		cout << "bitspersample: " << dsf.bitspersample << endl;
		cout << "samplecount: " << dsf.samplecount << endl;
		cout << "blocksizeperchannel: " << dsf.blocksizeperchannel << endl;
		cout << "datachunksize: " << dsf.datachunksize << endl;
		ifs.close();
	}
	return	0;
}
