#include <iostream>
using namespace std;
#include "dsf.h"
#include "dsf_load.h"
bool
dsf_check_header( dsf_t &dsf)
{
	if (memcmp(dsf.dsf, "DSD ", 4)) {
		// cerr.write(dsf.dsf, 4);
		cerr << ": DSD chunk not found, not DSF file." << endl;
		return	false;
	}
	if (dsf.dsfchunksize != 28) {
		cerr << dsf.dsfchunksize << ": dsfchunksize is not 28." << endl;
		return	false;
	}
	if (memcmp(dsf.fmt, "fmt ", 4)) {
		cerr << ": fmt chunk not found." << endl;
		return	false;
	}
	if (dsf.fmtchunksize != 52) {
		cerr << dsf.fmtchunksize << ": fmtchunksize is not 52." << endl;
		return	false;
	}
	if (dsf.version != 1) {
		cerr << dsf.version << ": version is not 1." << endl;
		return	false;
	}
	if (dsf.id != 0) {
		cerr << dsf.id << ": dsf id is not 0." << endl;
		return	false;
	}
	if (dsf.frequency != 2822400
		&& dsf.frequency != 5644800
		&& dsf.frequency != 11289600
		&& dsf.frequency != 11289600*2
		&& dsf.frequency != 11289600*4) {
		cerr << dsf.frequency << ": not supported frequency." << endl;
		return	false;
	}
	if (dsf.bitspersample != 1 && dsf.bitspersample != 8) {
		cerr << dsf.bitspersample << ": bitspersample is not 1 or 8." << endl;
		return	false;
	}
	if (dsf.reserved != 0) {
		cerr << dsf.reserved << ": reserved is not 0." << endl;
		return	false;
	}
	if (memcmp(dsf.data, "data", 4)) {
		cerr << ": datachunk not found." << endl;
		return	false;
	}
	return	true;
}
bool
dsf_load( dsf_t &dsf, istream &is)
{
	is.read((char*)&dsf, sizeof(dsf));
	if (is.gcount() != sizeof(dsf)) {
		cerr << "file size(" << is.gcount() << ") < chunk size(" << sizeof(dsf)
			 << ")" << endl;
		return	false;
	}
	return	dsf_check_header(dsf);
}
